﻿#if       !defined(INCLUDED_SZ_ARCHIVE_OPEN_CLIENT_CALLBACK)
#define            INCLUDED_SZ_ARCHIVE_OPEN_CLIENT_CALLBACK

#if       !defined(INCLUDED_SZ_COMMON)
#include  <szCommon.hpp>
#endif // !defined(INCLUDED_SZ_COMMON)

SZ_NS_BEG(szpp)

/// <summary>
/// アーカイブを開く際の進行状況などをクライアントに知らせるためのコールバック型。
/// クライアント側で派生クラスを実装して、そのポインタを SevenZip++ に登録する。
/// </summary>
class SZ_SPEC ArchiveOpenClientCallback
{
public:

  /// <summary>
  /// 処理全体の分量を知らせるためのメソッド。
  /// </summary>
  /// <param name="files">全体のファイル数を表す。0 のときはファイルが 0 個という意味ではなく、本パラメータの値を使用してはいけないことを意味する。</param>
  /// <param name="bytes">全体のバイト数を表す。0 のときはバイト数が 0 という意味ではなく、本パラメータの値を使用してはいけないことを意味する。</param>
  /// <returns>
  /// 処理を中断するかどうかを HRESULT 型で返す。そのまま処理を続行する場合は S_OK を、ユーザーが「キャンセル」ボタンを押したような場合には E_ABORT を返す。
  /// </returns>
  virtual HRESULT SetTotal(const u64 &files, const u64 &bytes) = 0;

  /// <summary>
  /// 完了した処理の分量を知らせるためのメソッド。
  /// </summary>
  /// <param name="files">完了したファイル数を表す。0 のときはファイルが 0 個という意味ではなく、本パラメータの値を使用してはいけないことを意味する。</param>
  /// <param name="bytes">完了したバイト数を表す。0 のときはバイト数が 0 という意味ではなく、本パラメータの値を使用してはいけないことを意味する。</param>
  /// <returns>
  /// 処理を中断するかどうかを HRESULT 型で返す。そのまま処理を続行する場合は S_OK を、ユーザーが「キャンセル」ボタンを押したような場合には E_ABORT を返す。
  /// </returns>
  virtual HRESULT SetCompleted(const u64 &files, const u64 &bytes) = 0;

};

SZ_NS_END(szpp)

#endif // !defined(INCLUDED_SZ_ARCHIVE_OPEN_CLIENT_CALLBACK)
